<?php

namespace App\Services;

use App\Facades\ExceptionLog;
use App\Models\BuyboxReport;
use App\Models\Item;
use App\Models\ItemActivity;
use App\Models\RepriceSetting;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;
use Exception;
use stdClass;
use App\Models\BuyBoxNotification;
use App\Models\RepricingHistory;
use App\Models\WinLostPrices;
use Illuminate\Support\Facades\App;

class DataProviderService
{
    const CLEAN_JSON_DATA = [
        'contentLayout',
        'seoItemMetaData',
        'idml',
        'reviews',
        'product' => [
            'ozarkAttributes',
            'preOrder',
            'subscription',
            'badges',
            'canonicalUrl',
            'category',
            'imageInfo',
            'variantCriteria',
            'promoData',
            'selectedVariantIds',
            'variantProductIdMap',
            'imageMap',
            'variantsMap',
            'shortDescription',
            'suppressReviews',
            'brand',
            'brandUrl',
            'rhPath',
            'aaiaBrandId',
            'ironbankCategory',
            'type',
            'manufacturerName',
            'name',
        ],
    ];

    public $item;
    public $offersCount;
    public $offers;
    public $itemData;
    public $min;
    public $max;
    public $bbWin;
    public $bbWinFromFeed;
    public $scrappedData;
    public $itemRule;
    public $itemActivity;
    public $lastItemActivity;
    public $bbNotification;
    public $sellerDisplayName;
    public $bbWinnerPrice;
    public $compPrice;
    public $bbWinnerSpeed;
    public $bbWinnerPro;
    public $newPrice;
    public $bbWinOld;
    public $lastState;
    public $lastItemActivities;
    public $lastItemActivitiesCount;
    public $secondaryOfferPrice;
    public $secondaryOfferSpeed;
    public $secondaryOfferPro;
    public $nearBelowCompPro;
    public $currentItemPrice;
    public $currentItemSpeed;
    public $currentItemPro;
    public $nearBelowCompPrice;
    public $nearBelowCompSpeed;
    public $abs;
    public $percent;
    public $high;
    public $low;
    public $rule;
    public $ruleText;
    public $hiFromLost;
    public $cancelled;
    public $ruleType;
    public $compShipType;
    public $low_reg;
    public $low_wfs;
    public $low_2d;
    public $low_walmart;
    public $hi_reg;
    public $hi_wfs;
    public $hi_2d;
    public $hi_walmart;
    public $hi_lost;
    public $hi_lost_reg;
    public $hi_lost_wfs;
    public $hi_lost_2d;
    public $hi_lost_walmart;
    public $bbWin_old;
    public $additionalRuleText;
    public $nearAboveCompPrice;
    public $nearAboveCompSpeed;
    public $winLostPrice;

    public function __construct($item, $scrappedData = null, $bbNotification = null)
    {
        try{
            $this->lastState = null;
            $this->item = $item;

            $this->scrappedData = $scrappedData;
            $this->offers = $this->getAllOffersFromScrappedData();
            $this->itemData = $this->getAllDataFromScrappedData();
            $this->itemRule = false;
            $this->bbNotification = $bbNotification;
            //For test Local $this->bbNotification = BuyBoxNotification::where('item_id', $this->item->id)->latest('id')->first();
            $this->min = $item->min_price;
            $this->max = $item->max_price;
            $this->sellerDisplayName = $this->getSellerDisplayName();
            $this->winLostPrice = WinLostPrices::where('item_id', $this->item->id)->first();
            $this->bbWin = $this->getCurrentScrappedBBStatus();
            $this->bbWinFromFeed = $this->getCurrentBbFromNotification();
            $this->getLastItemActivities();
            $this->getLastItemActivity();
            $this->getBbWinOld();
            //dd($this->bbWin_old, $this->bbWin);
            $this->getNearCompPrice();
            //dd( $this->compPrice);
            $this->nearBelowCompPro = true;
            $this->compShipType = null;
            $this->hiAndLow();
            $this->getPrevState();
            $this->cancelled = false;
            $this->ruleType = 'undefined rule';
            $this->getCompData();
            $this->getHiAndLowOtherCompsSpeed();

            if (!$this->lastState){
                $this->lastState = 'noHistory';
            }



        } catch (Exception $e){
            ExceptionLog::add($e, $this);
            if (App::environment('local')) { dump('Line: ' . $e->getLine() . '\r\n' . 'File: ' . $e->getFile() . '\r\n' . 'Message: ' . $e->getMessage() . '\r\n'); }

            return false;
        }
    }

    private function getLastItemActivities()
    {
        try{
            $this->lastItemActivities = ItemActivity::  where('item_id', $this->item->id)->
                                                    where('status','1')->
                                                    where(function ($q) {
                                                        $q->where('cancelled', null)->
                                                            orWhere('cancelled', false);
                                                    })->
                                                    orderBy('id', 'desc')->
                                                    get();
        } catch (Exception $e) {
            ExceptionLog::add($e, $this);
            if (App::environment('local')) { dump('Line: ' . $e->getLine() . '\r\n' . 'File: ' . $e->getFile() . '\r\n' . 'Message: ' . $e->getMessage() . '\r\n'); }

            return false;
        }
    }

    private function getBbWinOld()
    {
        if ($this->winLostPrice){
            $this->bbWinOld = $this->winLostPrice->bb_win;
        } else {
            $this->bbWinOld = null;
        }
    }

    private function getAllOffersFromScrappedData()
    {
        try{
            if ($this->scrappedData['offers']){
                $offers = json_decode($this->scrappedData['offers']);

                if (!empty($offers->data->product->allOffers)){
                    return $offers->data->product->allOffers;
                }
            }

            return false;
        } catch (Exception $e){
            ExceptionLog::add($e, $this);
            if (App::environment('local')) { dump('Line: ' . $e->getLine() . '\r\n' . 'File: ' . $e->getFile() . '\r\n' . 'Message: ' . $e->getMessage() . '\r\n'); }

            return false;
        }
    }

    public function getAllDataFromScrappedData()
    {
        try{
            if (!empty($this->scrappedData['itemData'])){
                $data = $this->scrappedData['itemData'];

                foreach($data as $itemJson){
                    $item = $itemJson['json'];
                }

                for ($i = 0; $i < count($this->scrappedData['itemData']); $i++){
                    if (!empty($this->scrappedData['itemData'][$i]['json'])){
                        $pageData = json_decode($this->scrappedData['itemData'][$i]['json']);
                        break;
                    }
                    $pageData = null;
                }

                $params = self::CLEAN_JSON_DATA;

                foreach($params as $key => $value){
                    if (is_array($value)){
                        foreach($value as $subParam){
                            unset($pageData->{$key}->{$subParam});
                        }
                    } else {
                        unset($pageData->{$value});
                    }
                }

                return $pageData->product;
            }

            return false;
        } catch (Exception $e){
            ExceptionLog::add($e, $this);
            if (App::environment('local')) { dump('Line: ' . $e->getLine() . '\r\n' . 'File: ' . $e->getFile() . '\r\n' . 'Message: ' . $e->getMessage() . '\r\n'); }

            return false;
        }
    }

    private function getSellerDisplayName ()
    {
        try{
            $lastSellerRecord = DB::table('buybox_reports')
                                    ->where('walmart_key_id', $this->item->walmart_key_id)
                                    ->latest('created_at')
                                    ->first();

            return $lastSellerRecord->seller_name;
        } catch (Exception $e){
            ExceptionLog::add($e, $this);
            if (App::environment('local')) { dump('Line: ' . $e->getLine() . '\r\n' . 'File: ' . $e->getFile() . '\r\n' . 'Message: ' . $e->getMessage() . '\r\n'); }

            return false;
        }
    }

    private function getCurrentScrappedBBStatus ()
    {
        try{
            if (!empty($this->offers)){
                if (count($this->offers) >= 1){
                    if ($this->offers[0]->sellerDisplayName == $this->sellerDisplayName){
                        return true;
                    }

                    return false;
                }
            } else {
                if ($this->itemData->sellerDisplayName == $this->sellerDisplayName){
                    return true;
                }
            }

            return false;
        } catch (Exception $e){
            ExceptionLog::add($e, $this);
            if (App::environment('local')) { dump('Line: ' . $e->getLine() . '\r\n' . 'File: ' . $e->getFile() . '\r\n' . 'Message: ' . $e->getMessage() . '\r\n'); }

            return false;
        }
    }

    private function getCurrentBbFromNotification()
    {
        try{
            if ($this->bbNotification) {
                return ($this->bbNotification->winning_seller_name == $this->sellerDisplayName) ? true : false;
            }

            return false;
        } catch (Exception $e){
            ExceptionLog::add($e, $this);
            if (App::environment('local')) { dump('Line: ' . $e->getLine() . '\r\n' . 'File: ' . $e->getFile() . '\r\n' . 'Message: ' . $e->getMessage() . '\r\n'); }

            return false;
        }
    }

    private function getLastItemActivity()
    {
        try{
            if (count($this->lastItemActivities)){
                $this->lastItemActivity = $this->lastItemActivities[0];
            } else {
                $this->lastItemActivity = false;
            }
        } catch (Exception $e){
            ExceptionLog::add($e, $this);
            if (App::environment('local')) { dump('Line: ' . $e->getLine() . '\r\n' . 'File: ' . $e->getFile() . '\r\n' . 'Message: ' . $e->getMessage() . '\r\n'); }

            return false;
        }
    }

    private function getNearCompPrice()
    {
        try{
            if ($this->offers){
                $offersCount = count($this->offers);

                if (($offersCount == 1) && ($this->item->published_status == 'PUBLISHED')){
                    if($this->offers[0]->sellerDisplayName != $this->getSellerDisplayName()){
                        $this->newPrice = $this->currentItemPrice;
                        $this->ruleText = $this->rule = 'Looks some issue, the item is not present on Walmart';
                        $this->cancelled = true;
                    } else {
                        $this->bbWinnerPrice = $this->currentItemPrice = $this->offers[0]->priceInfo->currentPrice->price;
                        $this->bbWinnerSpeed = $this->currentItemSpeed = $this->getShippingSpeed($this->offers[0]->shippingOption->slaTier, $this->offers[0]->wfsEnabled, $this->offers[0]->sellerDisplayName);
                        $this->bbWinnerPro = $this->currentItemPro = $this->offers[0]->hasSellerBadge;
                        $this->nearBelowCompPrice = 0;
                        $this->nearBelowCompSpeed = 'reg';
                    }
                } else {
                    if (($this->offers) && ($offersCount > 1)){
                        if ($this->bbWin == 1){
                            $this->bbWinnerPrice = $this->currentItemPrice = $this->offers[0]->priceInfo->currentPrice->price;
                            $this->bbWinnerSpeed = $this->currentItemSpeed =$this->getShippingSpeed($this->offers[0]->shippingOption->slaTier, $this->offers[0]->wfsEnabled, $this->offers[0]->sellerDisplayName);
                            $this->bbWinnerPro = $this->currentItemPro = $this->offers[0]->hasSellerBadge;

                            $this->secondaryOfferPrice = $this->compPrice = $this->offers[1]->priceInfo->currentPrice->price;
                            $this->secondaryOfferSpeed =  $this->compShipType = $this->getShippingSpeed($this->offers[1]->shippingOption->slaTier, $this->offers[1]->wfsEnabled, $this->offers[1]->sellerDisplayName);
                            $this->secondaryOfferPro = $this->offers[1]->hasSellerBadge;
                        } else {
                            $this->bbWinnerPrice = $this->compPrice = $this->offers[0]->priceInfo->currentPrice->price;
                            $this->bbWinnerSpeed = $this->compShipType =$this->getShippingSpeed($this->offers[0]->shippingOption->slaTier, $this->offers[0]->wfsEnabled, $this->offers[0]->sellerDisplayName);
                            $this->bbWinnerPro = $this->offers[0]->hasSellerBadge;

                            for($i = 0 ; $i < count($this->offers); $i++){
                                if ($this->offers[$i]->sellerDisplayName == $this->sellerDisplayName){

                                    $this->currentItemPrice = $this->offers[$i]->priceInfo->currentPrice->price;
                                    $this->currentItemSpeed = $this->getShippingSpeed($this->offers[$i]->shippingOption->slaTier, $this->offers[$i]->wfsEnabled, $this->offers[$i]->sellerDisplayName);
                                    $this->currentItemPro = $this->offers[$i]->hasSellerBadge;

                                    if ($i > 0){
                                        $this->nearAboveCompPrice = $this->offers[$i-1]->priceInfo->currentPrice->price;
                                        $this->nearAboveCompSpeed = $this->getShippingSpeed($this->offers[$i-1]->shippingOption->slaTier, $this->offers[$i-1]->wfsEnabled, $this->offers[$i-1]->sellerDisplayName);
                                    }

                                    if (($i < count($this->offers)-1) && (count($this->offers) > 2)) {
                                        $this->nearBelowCompPrice = $this->offers[$i+1]->priceInfo->currentPrice->price;
                                        $this->nearBelowCompSpeed = $this->getShippingSpeed($this->offers[$i+1]->shippingOption->slaTier, $this->offers[$i+1]->wfsEnabled, $this->offers[$i+1]->sellerDisplayName);
                                    }
                                }
                            }
                        }

                        if(!$this->currentItemSpeed){
                            $this->currentItemSpeed ='reg';
                        }

                        if(!$this->bbWinnerSpeed){
                            $this->bbWinnerSpeed ='reg';
                        }
                        if(!$this->secondaryOfferSpeed){
                            $this->secondaryOfferSpeed ='reg';
                        }

                        if(!$this->compShipType){
                            $this->compShipType ='reg';
                        }

                    } else {
                        if ($this->bbWin == 1){
                            $this->bbWinnerPrice = $this->currentItemPrice = $this->itemData->priceInfo->currentPrice->price;
                            $this->bbWinnerSpeed = $this->currentItemSpeed = $this->getShippingSpeed($this->itemData->shippingOption->slaTier, $this->itemData->wfsEnabled, $this->itemData->sellerDisplayName);
                            $this->bbWinnerPro = $this->currentItemPro = $this->itemData->hasSellerBadge;
                        } elseif ($this->bbWin == 0) {
                            $this->bbWinnerPrice = $this->compPrice = $this->itemData->priceInfo->currentPrice->price;
                            $this->bbWinnerSpeed = $this->getShippingSpeed($this->itemData->shippingOption->slaTier, $this->itemData->wfsEnabled, $this->itemData->sellerDisplayName);
                            $this->bbWinnerPro = $this->itemData->hasSellerBadge;

                            $this->currentItemPrice = $this->item->current_price;
                            $this->currentItemSpeed = 'reg';
                            $this->currentItemPro = false;
                        }

                        if (!empty($this->itemData->secondaryOfferPrice->currentPrice->price)){
                            $this->secondaryOfferPrice = $this->itemData->secondaryOfferPrice->currentPrice->price;
                        } else {
                            $this->secondaryOfferPrice = null;
                        }

                        $this->secondaryOfferSpeed = 'reg';
                        $this->secondaryOfferPro = false;

                        $this->nearBelowCompPrice = 0;
                        $this->nearBelowCompSpeed = 'reg';
                        $this->nearBelowCompPro = false;

                        if(!$this->currentItemSpeed){
                            $this->currentItemSpeed ='reg';
                        }

                        if(!$this->bbWinnerSpeed){
                            $this->bbWinnerSpeed ='reg';
                        }
                        if(!$this->secondaryOfferSpeed){
                            $this->secondaryOfferSpeed ='reg';
                        }
                    }
                }
            } else {
                $this->newPrice = $this->currentItemPrice;
                $this->ruleText = $this->rule = 'Looks some issue with scrapping offers on Walmart';
                $this->cancelled = true;
            }
        } catch (Exception $e){
            ExceptionLog::add($e, $this);
            if (App::environment('local')) { dump('Line: ' . $e->getLine() . '\r\n' . 'File: ' . $e->getFile() . '\r\n' . 'Message: ' . $e->getMessage() . '\r\n'); }

            return false;
        }
    }

    private function getShippingSpeed($shippingMethod, $wfs, $sellerDisplayName)
    {
        try {
            switch ($shippingMethod) {
                case 'THREE_TO_FIVE_DAY':
                    if ($wfs){
                        $shippingType = 'wfs';
                    } else {
                        $shippingType = 'reg';
                    }
                    break;

                case 'TWO_DAY':
                    if ($wfs){
                        $shippingType = 'wfs';
                    } else {
                        $shippingType = '2d';
                    }
                    break;

                case 'ONE_DAY':
                    if ($sellerDisplayName == 'Walmart.com'){
                        $shippingType =  'walmart';
                    } else {
                        $shippingType = 0;
                    }
                    break;

                default:
                    $shippingType = '2d';
            }

            return $shippingType;
        } catch (Exception $e){
            ExceptionLog::add($e, $this);
            if (App::environment('local')) { dump('Line: ' . $e->getLine() . '\r\n' . 'File: ' . $e->getFile() . '\r\n' . 'Message: ' . $e->getMessage() . '\r\n'); }

            return false;
        }
    }

    private function getPrevState() //copy
    {
        try{
            if (!$this->winLostPrice){
                return $this->lastState = 'noHistory';
            }

            if (($this->winLostPrice->lost_current == 0) || ($this->winLostPrice->win_current == 0) || ($this->winLostPrice->lost_current == null) || ($this->winLostPrice->win_current == null)){
                return $this->lastState = 'noHistory';
            }

            if (count($this->lastItemActivities) >= 1) {
                if (($this->high != -9999.12345678) && ($this->low != 9999.12345678)){
                    if($this->bbWin){
                        if($this->bbWinOld){
                            $this->lastState = 'wonAfterWin';
                        } else {
                            $this->lastState = 'wonAfterLost';
                        }
                    } else {
                        if($this->bbWinOld){
                            $this->lastState = 'lostAfterWin';
                        } else {
                            $this->lastState = 'lostAfterLost';
                        }
                    }
                } else {
                    $this->additionalRuleText = 'Or HBBWP or LBBLP is undefined. ';
                    $this->lastState = 'noHistory';
                }

                $this->lastItemActivitiesCount = count($this->lastItemActivities);
            } else {
                $this->lastState = 'noHistory';
                $this->lastItemActivitiesCount = 0;
            }

        } catch (Exception $e){
            ExceptionLog::add($e, $this);
            if (App::environment('local')) { dump('Line: ' . $e->getLine() . '\r\n' . 'File: ' . $e->getFile() . '\r\n' . 'Message: ' . $e->getMessage() . '\r\n'); }

            return false;
        }
    }

    private function hiAndLow()
    {
        try{
            $this->percent = self::calcPercent($this->currentItemPrice, $this->bbWin ? $this->secondaryOfferPrice : $this->bbWinnerPrice);
            //$this->percent = $percent;

            if ($this->winLostPrice){
                if ($this->bbWin){
                    $this->low = $this->winLostPrice->lbblp_current;

                    if ($this->winLostPrice->hbbwp_current < $this->percent){
                        $this->high = $this->percent;
                    } else {
                        $this->high = $this->winLostPrice->hbbwp_current;
                    }
                } else {
                    if ($this->winLostPrice->lbblp_current > $this->percent){
                        $this->low = $this->percent;
                    } else {
                        $this->low = $this->winLostPrice->lbblp_current;
                    }

                    if ($this->winLostPrice->hbbwp_current > $this->low) {
                        $this->high = null;
                        $this->winLostPrice->hbbwp_current = null;
                        $this->winLostPrice->save();
                    } else {
                        $this->high = $this->winLostPrice->hbbwp_current;
                    }
                }
            } else {
                if ($this->bbWin){
                    $this->high = $this->percent;
                    $this->low = 9999.12345678;
                } else {
                    $this->low = $this->percent;
                    $this->high = -9999.12345678;
                }
            }

            if ($this->high == -9999.12345678) {
                $hi = 0;
            } else {
                $hi = $this->high;
            }

            if ($this->low == 9999.12345678) {
                $low = 0;
            } else {
                $low = $this->low;
            }

            $this->abs = abs($hi - $low);
        } catch (Exception $e){
            ExceptionLog::add($e, $this);
            if (App::environment('local')) { dump('Line: ' . $e->getLine() . '\r\n' . 'File: ' . $e->getFile() . '\r\n' . 'Message: ' . $e->getMessage() . '\r\n'); }

            return false;
        }
    }

    private static function calcPercent ($itemPrice = null, $compPrice = 0)
    {
        try{
            if(isset($itemPrice)){
                    if(($compPrice ?? 0) > 0){
                        return ($itemPrice - $compPrice) / $compPrice;
                    }
                }

            return false;
        } catch (Exception $e){
            ExceptionLog::add($e, get_defined_vars());
            if (App::environment('local')) { dump('Line: ' . $e->getLine() . '\r\n' . 'File: ' . $e->getFile() . '\r\n' . 'Message: ' . $e->getMessage() . '\r\n'); }

            return false;
        }
    }

    private function getCompData()
    {
        try{
            if (!empty($this->offers)){
                $this->offersCount = count($this->offers);

                if($this->offersCount > 0){
                    for ($i = 0; $i < $this->offersCount; $i++){
                        if ($this->bbWin == 1){
                            if($this->offersCount > 1){
                                $this->compShipType = $this->getShippingSpeed($this->offers[1]->shippingOption->slaTier, $this->offers[1]->wfsEnabled,$this->offers[1]->sellerDisplayName);

                                if ($i > 1){
                                    $otherCompSpeed = $this->getShippingSpeed($this->offers[$i]->shippingOption->slaTier, $this->offers[$i]->wfsEnabled,$this->offers[$i]->sellerDisplayName);
                                }
                            } else{
                                $this->compShipType = null;
                            }
                        } elseif ($this->bbWin == 0) {
                            $this->compShipType = $this->getShippingSpeed($this->offers[0]->shippingOption->slaTier, $this->offers[0]->wfsEnabled,$this->offers[0]->sellerDisplayName);

                            if (($i >= 1) && ($this->getSellerDisplayName() != $this->offers[$i]->sellerDisplayName)){
                                $otherCompSpeed = $this->getShippingSpeed($this->offers[$i]->shippingOption->slaTier, $this->offers[$i]->wfsEnabled,$this->offers[$i]->sellerDisplayName);
                            }
                        }
                    }
                } else {
                    $this->offersCount = 0;
                }
            } else {
                $this->offersCount = 0;
            }
        } catch (Exception $e){
            ExceptionLog::add($e, $this);
            if (App::environment('local')) { dump('Line: ' . $e->getLine() . '\r\n' . 'File: ' . $e->getFile() . '\r\n' . 'Message: ' . $e->getMessage() . '\r\n'); }

            return false;
        }
    }

    private function getHiAndLowOtherCompsSpeed()
    {
        try{
            $this->low_reg = 0;
            $this->low_wfs = 0;
            $this->low_2d = 0;
            $this->low_walmart = 0;
            $this->hi_reg = 0;
            $this->hi_wfs = 0;
            $this->hi_2d = 0;
            $this->hi_walmart = 0;

            if ($this->bbWin == 1){
                $position = 0;
            } elseif ($this->bbWin == 0) {
                for ($i = 0; $i < $this->offersCount; $i++){
                    if($this->getSellerDisplayName() != $this->offers[$i]->sellerDisplayName){
                        $position = $i;
                    }
                }
            }

            if ($this->offers){
                for ($i = 0; $i < $this->offersCount; $i++){
                    if($this->offers[$i]->sellerDisplayName <> $this->getSellerDisplayName()){
                        $speed = $this->getShippingSpeed(   $this->offers[$i]->shippingOption->slaTier,
                                                            $this->offers[$i]->wfsEnabled,
                                                            $this->offers[$i]->sellerDisplayName
                                                        );
                        $offerPrice = (float)$this->offers[$i]->priceInfo->currentPrice->price;
                        $percentDiff = ($this->currentItemPrice - $offerPrice) / $offerPrice;

                        if ($i < $position){ //lost to current comp
                            switch ($speed) {
                                case 'walmart':
                                    $this->low_walmart = ($this->low_walmart == 0) ? $percentDiff : $this->low_walmart;
                                    break;
                                case 'wfs':
                                    $this->low_wfs = ($this->low_wfs == 0) ? $percentDiff : $this->low_wfs;
                                    break;
                                case '2d':
                                    $this->low_2d = ($this->low_2d == 0) ? $percentDiff : $this->low_2d;
                                    break;
                                case 'reg': //3-5 days
                                    $this->low_reg = ($this->low_reg == 0) ? $percentDiff : $this->low_reg;
                                    break;
                            }
                        } elseif($i > $position){ //Won to current comp
                            switch ($speed) {
                                case 'walmart':
                                    $this->hi_walmart = ($this->hi_walmart == 0) ? $percentDiff : $this->hi_walmart;
                                    break;
                                case 'wfs':
                                    $this->hi_wfs = ($this->hi_wfs == 0) ? $percentDiff : $this->hi_wfs;
                                    break;
                                case '2d':
                                    $this->hi_2d = ($this->hi_2d == 0) ? $percentDiff : $this->hi_2d;
                                    break;
                                case 'reg': //3-5 days
                                    $this->hi_reg = ($this->hi_reg == 0) ? $percentDiff : $this->hi_reg;
                                    break;
                            }
                        }
                    }
                }
            }

        } catch (Exception $e){
            ExceptionLog::add($e, $this);
            if (App::environment('local')) { dump('Line: ' . $e->getLine() . '\r\n' . 'File: ' . $e->getFile() . '\r\n' . 'Message: ' . $e->getMessage() . '\r\n'); }

            return false;
        }
    }
}
