<?php

namespace App\Jobs;

use App\Models\Item;
use App\Models\ItemActivity;
use App\Models\Event;
use App\Models\Scraping;
use App\Models\WalmartKey;
use App\Services\ScraperService;
use App\Services\WalmartService;
use Carbon\Carbon;
use Illuminate\Support\Arr;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Str;
use App\Services\PauseService;
class ScrapItemOld extends SequencedJob
{
    private $item;
    private $creds;
    /**
     * @var bool
     */
    private $reprice;

    private $zip_codes = [
        'Los Angeles' => '90011',
        'San Francisco' => '94102',
//        'San Diego' => '92115',
//        'San Jose' => '95125',
        'New York' => '10026',
//        'Houston' => '77001',
//        'San Antonio' => '78006',
//        'Dallas' => '75001',
//        'Austin' => '73301',
//        'Fort Worth' => '76008'
    ];

    private $wm_key_scrapers = [
        1 => ['104.248.53.48:9999' , '147.182.133.249:9999'],
        2 => ['104.248.53.48:9999' , '147.182.133.249:9999'],
        10 => ['104.248.53.48:9999' , '147.182.133.249:9999'],
        11 => ['104.248.53.48:9999' , '147.182.133.249:9999'],
        12 => ['104.248.53.48:9999' , '147.182.133.249:9999'],
        9 => ['104.248.53.48:9999' , '147.182.133.249:9999']
    ];

    private $short_scrapers = [
        '104.248.53.48:9999', '147.182.133.249:9999'
    ];

    /**
     * Create a new job instance.
     *
     * @param $item
     * @param array $chain_data
     */
    public function __construct($item, $chain_data = [])
    {
        $this->item = $item;
        $this->chain_data = $chain_data;
        $this->creds = WalmartKey::find($item->walmart_key_id);
        if ($this->getChainDataProperty('short')) {
//            $this->setQueue("walmart.scraper");
        } else {
//            $this->setQueue("walmart.scraper.{$item->walmart_key_id}");
        }
    }

    private function scrapers()
    {
        $scrapers = env('SCRAPER_HOSTS', 'New York=127.0.0.1:8000');

        $result = [];

        foreach (explode(',', $scrapers) as $location) {
            list($name, $host) = explode('=', $location);
            $result[$name] = $host;
        }

        return $result;
    }

    public function work()
    {
        $this->chain_data['new_scraping'] = true;

        $scraping = $this->getChainDataProperty('scraping_record');

        if (!$scraping) {
            $scraping = Scraping::where('item_id', $this->item->id)
                ->where('scraped_at', '>', now()->subHours(6))
                ->first();
        }

        if ($scraping) {
            $this->chain_data['new_scraping'] = false;
            $this->chain_data['scrape_data'] = $scraping->data;
            return $scraping->data;
        }

        if ($this->getChainDataProperty('short')) {
            $host = Arr::random($this->short_scrapers);
        } else {
            $host = Arr::random($this->short_scrapers);
        }
        $data = $this->getResponse($host);

        if ($this->getChainDataProperty('short')) {
            if (isset($data['product'])) {
                $this->chain_data['scrape_data'] = $data;
                return $data;
            }
        }

        if (!empty($data['itemData'][0]['json']) && !empty($data['offers'])) {
            $this->chain_data['scrape_data'] = $data;
            if ($this->getChainDataProperty('v2')) {
                return [
                    'offers' => $data['offers'],
                    'errors' => $data['errors']
                ];
            }
            return $data;
        }

        if ($scraping = Scraping::where('item_id', $this->item->id)->first()) {
            $this->chain_data['new_scraping'] = false;
            $this->chain_data['scrape_data'] = $scraping->data;
            return $scraping->data;
        }

        return null;
//        if (env('SCRAP_ANYWAY', 0) && empty($data['itemData'])) {
//
//            $hosts = $this->hosts;
//            shuffle($hosts);
//            foreach ($hosts as $host) {
//                $data = $this->getResponse($host);
//                if (!empty($data['itemData'])) {
//                    break;
//                }
//            }
//        }
    }

    public function next($work_data)
    {
        $this->chain_data['activity'] = ItemActivity::where('item_id', $this->item->id)
            ->whereIn('status', [ItemActivity::STATUS_VERIFICATION, ItemActivity::STATUS_COMPLETED])
            ->orderByDesc('id')
            ->first();

        /*$this->chain_data['event'] = Event::where('item_id', $this->item->id)
            ->whereIn('status', [Event::STATUS_VERIFICATION, Event::STATUS_COMPLETED])
            ->orderByDesc('id')
            ->first();*/

        $activity = $this->getChainDataProperty('activity');

        if (!$work_data) {
            ItemActivity::create([
                'item_id' => $this->item->id,
                'description' => 'Unsuccessful scrapping. Next try after 5-10 minutes. Changing Proxy...',
                'status' => ItemActivity::STATUS_SCRAP_ERROR
            ]);

            /*Event::create([
                'item_id' => $this->item->id,
                'status' => Event::STATUS_SCRAP_ERROR
            ]);*/

            return;
        }

        if ($this->getChainDataProperty('new_scraping')) {
            Scraping::updateOrCreate([
                'item_id' => $this->item->id
            ], [
                'scraped_at' => now(),
                'data' => $work_data,
            ]);
        }

        if ($this->isNotFound()) {
            return;
        }

        $service = new WalmartService($this->creds);
        list($item_api_current_price, $catalog_api_price) = $service->refreshItemPriceAndGetCatalogPrice($this->item, 1);
        // $catalog_api_price = $service->getCatalogPrice($this->item);
        // $item_api_current_price = $service->refreshItemPrice($this->item);

        if ($activity && $activity->status == ItemActivity::STATUS_VERIFICATION) {
//            dump('Activity status before check', $activity->status);

            if ($this->getChainDataProperty('v2')) {
                $this->chain_data['event_type'] = $this->getChainDataProperty('short') ? 3 : 4;
            }

            CheckRepricedItem::dispatchSync($this->item, array_merge(
                $this->chain_data,
                [
                    'catalog_api_buy_box_price' => $catalog_api_price,
                    'item_api_current_price' => $item_api_current_price,
                    'activity_type' => $activity->manual ? 'manualReprice' : 'updateReprice',
                ]
            ));

            $activity->refresh();
//            dump('Activity status after check', $activity->status);
        }

        switch ($this->getChainDataProperty('target')) {
            case 'reprice':
                if ($this->getChainDataProperty('v2')) {
                    $this->chain_data['catalog_api_buy_box_price'] = $catalog_api_price;
                    $this->chain_data['item_api_current_price'] = $item_api_current_price;
                    $this->chain_data['activity'] = ItemActivity::create(['item_id' => $this->item->id,
                        'status' => 0,
                        'catalog_api_price_before' => $catalog_api_price,
                        'item_api_current_price_before' => $item_api_current_price,
                        'description' => 'Start repricing. Collecting data...']);
                    $this->chain_data['event_type'] = $this->getChainDataProperty('short') ? 3 : 4;
                    /* $this->chain_data['event'] = Event::create(['item_id' => $this->item->id,
                        'status' => 0,
                        'event_type' =>  $this->getChainDataProperty('short') ? 3 : 4]);*/
                    EventProcess::dispatchSync($this->item, $this->chain_data);
                    return;
                }
                if ($activity) {
                    if ($activity->status == ItemActivity::STATUS_VERIFICATION) {
                        return;
                    }

                    $activity_after_current = ItemActivity::select('id')
                        ->where('item_id', $this->item->id)
                        ->whereNotIn('status', [ItemActivity::STATUS_SCRAP_ERROR, ItemActivity::STATUS_TIMEOUT])
                        ->where('id', '>', $activity->id)
                        ->first();

                    if ($activity_after_current) {
                        return;
                    }
                }


                $this->chain_data['activity'] = ItemActivity::create(['item_id' => $this->item->id,
                    'status' => 0,
                    'description' => 'Start repricing. Collecting data...']);
                Reprice::dispatch($this->item, $this->chain_data);
                break;
            case 'print':
                $work_data['date'] = Carbon::now();
                $file_path = base_path("scraper/test_results/item_{$this->item->id}_output.json");
                file_put_contents($file_path, json_encode($work_data));
                break;
        }
    }

    private function isNotFound()
    {
        //return false;
        $scrape = $this->getChainDataProperty('scrape_data');

        if (!isset($scrape['errors'])) {
            return false;
        }

        $errors = $scrape['errors'];

        if (isset($errors[0]) && $errors[0]['message'] === '404') {
            //$this->item->is_repricing = false;

            PauseService::update($this->item, PauseService::NEXT_PAUSE, 3);
            $item_slug = $this->walmartSlug($this->item->title);

            $path = "/ip/{$item_slug}/{$this->item->walmart_item_id}";
            $item_url = "https://www.walmart.com$path";

            $activity = ItemActivity::create([
                'item_id' => $this->item->id,
                'description' => "Item not found. Item page: {$item_url}",
                'status' => ItemActivity::STATUS_SCRAP_ERROR
            ]);

            $event = Event::create([
                'item_id' => $this->item->id,
                'status' => Event::STATUS_SCRAP_ERROR
            ]);

            return true;
        }
        return false;
    }

    private function getResponse($host = null)
    {
        if (env('SCRAPER_TEST_MODE', 0)) {
            $file_path = base_path("scraper/test_results/item_{$this->item->id}_output.json");
            if (!file_exists($file_path)) {
                shell_exec('SCRAPER_TEST_MODE=0 php artisan item:getOffers ' . $this->item->id);
            }
            return json_decode(file_get_contents($file_path), true);
        }
        $pass = env('SCRAPER_PASSWORD','');

        $locations = [];
        $itemData = [];

        $location = Item::SCRAPING_LOCATIONS[$this->item->repricing_location];
        if (!$host) {
            $host = $this->scrapers()[$location];
        }

        $response = Http::withBasicAuth('scraper', $pass)
            ->post('http://' . $host . '/scraper', [
                'item' => $this->item->toArray(),
                'use_browserless' => false,
                //'short' => $this->getChainDataProperty('short') // тут всегда true // не, теперь нихуя
                'short' => false // тут всегда true // не, теперь нихуя
            ]);

        $result = $response->json();

        if ($this->getChainDataProperty('short')) {
//            return $result;
        }

        if (isset($result['locations'])) {
            $locations = array_merge($locations, $result['locations']);
        }

        if (isset($result['itemData'])) {
            $itemData = array_merge($itemData, $result['itemData']);
        }
        return [
            'errors' => $result['errors'] ?? [],
            'locations' => $locations,
            'itemData' => $itemData,
            'offers' => $result['offers'] ?? ''
        ];
    }

    private function walmartSlug($title)
    {
        $title = Str::ascii($title, 'en');
        $separator = '-';

        // Convert all underscores into separator
        $flip = '_';

        $title = preg_replace('!['.preg_quote($flip).']+!u', $separator, $title);

        // Replace @ with the word 'at'
        $title = str_replace('@', $separator.'at'.$separator, $title);

        // Remove all characters that are not the separator, letters, numbers, or whitespace.
        $title = preg_replace('![^'.preg_quote($separator).'\pL\pN\s]+!u', '', $title);

        // Replace all separator characters and whitespace by a single separator
        $title = preg_replace('!['.preg_quote($separator).'\s]+!u', $separator, $title);

        return trim($title, $separator);
    }
}
